import py_trees
import time

class TimerBehavior(py_trees.behaviour.Behaviour):
    def __init__(self, duration: float, name: str = "Timer"):
        super(TimerBehavior, self).__init__(name)
        self.duration = duration
        self.start_time = None

    def initialise(self) -> None:
        self.start_time = time.time()

    def update(self) -> py_trees.common.Status:
        if time.time() - self.start_time >= self.duration:
            return py_trees.common.Status.SUCCESS
        return py_trees.common.Status.RUNNING
